Rem AnimationEncyclopedia.vbs
Rem An InDesign VBScript
Rem 
Rem Author:  Brenda Burden
Rem Creates a 6-page sample doc demonstrating the new InDesign Animation feature

Rem  Search Reference
Rem  PAGE ONE - Sample of Animation Properties 
Rem  PAGE TWO - Sample of all Animation Events
Rem  PAGE THREE - Sample of Additional Animation Properties and Settings, including Duration, Play count, Loop, Speed and Origin
Rem  PAGE FOUR - Sample of Animate To, Animate From, To Current location
Rem  PAGE FIVE - Sample of creating Timing Groups, setting Delays, and looping a Timing Group
Rem  PAGE SIX - Complex A-B-C-D animation that can be created only through scripting (cannot be created in the UI)
main
function main()
	Set myInDesign = CreateObject("InDesign.Application.2022")
	Set myDocument = myInDesign.documents.add
	mySetUnits myInDesign, idMeasurementUnits.idInches
	myDocument.transparencyPreferences.blendingSpace = idBlendingSpace.idRGB
	myDocument.documentPreferences.facingPages = false
	myDocument.documentPreferences.pageWidth = 11.111
	myDocument.documentPreferences.pageHeight = 8.333
	Set myRed = myMakeColor(myInDesign, "Red", idColorSpace.idRGB, idColorModel.idProcess, Array(255, 0, 0))
	Set myGreen = myMakeColor(myInDesign, "Green", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 255, 0))
	Set myBlue = myMakeColor(myInDesign, "Blue", idColorSpace.idRGB, idColorModel.idProcess, Array(0, 0, 255))
	Set myPurple = myMakeColor(myInDesign, "Purple", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 0, 255))
	Set myLightGray = myMakeColor(myInDesign, "Light Gray", idColorSpace.idRGB, idColorModel.idProcess, Array(200, 200, 200))
	Set myNoneSwatch = myDocument.swatches.item("None")
	Rem 
	Rem Page 1
	Rem 
	Rem Create a motion path using motionPathPoints. This is similar to drawing a regular path using the
	Rem entirePath property. If you wish to set keyframes to correspond to points in the path, use motionPath 
	Rem instead of motionPathPoints. See example on Page 6.
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	myMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565, 0),Array(565, 0),Array(565, 0)) ),true)
	myCurvedMotionPath = Array(Array(Array(Array(0,0),Array(0,0),Array(0,0)),Array(Array(565,0),Array(565,-150),Array(565,0)) ),true) 
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Create a background rectangle.
	myMakeRectangle myDocument.pages.item(1), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(.25,0,1,11.111), "Animation Properties", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(1.25,1,1.625,10.5), "Motion Path", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(2.25,1,2.625,10.5), "Rotation", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(3.25,1,3.625,10.5), "Opacity", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(4.25,1,4.625,10.5), "Scale", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(5.25,1,5.625,10.5), "Combination", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(6.25,1,6.625,10.5), "Color Fade", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(1), Array(7.25,1,7.625,10.5), "Motion Path with Curve", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P1 = myMakeRectangle(myDocument.pages.item(1), Array(1.625,1,2,2), "Motion Path Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P1 = myMakeRectangle(myDocument.pages.item(1), Array(2.625,1,3,2), "Rotation Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P1 = myMakeRectangle(myDocument.pages.item(1), Array(3.625,1,4,2), "Opacity Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P1 = myMakeRectangle(myDocument.pages.item(1), Array(4.625,1,5,2), "Scale Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P1 = myMakeRectangle(myDocument.pages.item(1), Array(5.625,1,6,2), "Combination Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Blue", myBlue, myNoneSwatch, 0)
	Set myRectangle7P1 = myMakeRectangle(myDocument.pages.item(1), Array(6.625,1,7,2), "Color Fade Rectangle Purple", myPurple, myNoneSwatch, 0)
	Set myRectangle8P1 = myMakeRectangle(myDocument.pages.item(1), Array(7.625,1,8,2), "Motion Path with Curve Rectangle", myPurple, myNoneSwatch, 0)
	Rem Add animation properties.
	myRectangle1P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle2P1.animationSettings.rotationArray = Array(Array(0, 0), Array(23, 270))
	myRectangle3P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle3P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,10))  
	myRectangle4P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle4P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,20))  
	myRectangle4P1.animationSettings.scaleYArray = Array(Array(0,100.0),Array(23,20))  
	myRectangle5P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle5P1.animationSettings.scaleXArray = Array(Array(0,100),Array(23,120))  
	myRectangle5P1.animationSettings.scaleYArray = Array(Array(0,100),Array(23,10))  
	myRectangle5P1.animationSettings.rotationArray = Array(Array(0,0),Array(23,-270))  
	myRectangle5P1.animationSettings.opacityArray = Array(Array(0,100),Array(23,25))  
	myRectangle6P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle6P1.animationSettings.opacityArray = Array(Array(0,0),Array(23,100)) 
	myRectangle7P1.animationSettings.motionPathPoints = myMotionPath
	myRectangle7P1.animationSettings.opacityArray = Array(Array(0,100),Array(23, 50)) 
	myRectangle8P1.animationSettings.motionPathPoints = myCurvedMotionPath
	Set myPageOneTimingSettings = myDocument.spreads.item(1).timingSettings
	Rem Remove the default On Page Load timing list.
	myPageOneTimingSettings.timingLists.item(1).delete
	Rem Add an On Page Click timing list.
	Set p1TimingOnPageClickList = myPageOneTimingSettings.timingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Rem Add Animations as separate On Page Click Timing Groups
	Set p1timingGroup1 = p1TimingOnPageClickList.timingGroups.add(myRectangle1P1, 0)
	Set p1timingGroup2 = p1TimingOnPageClickList.timingGroups.add(myRectangle2P1, 0) 
	Set p1timingGroup3 = p1TimingOnPageClickList.timingGroups.add(myRectangle3P1, 0) 
	Set p1timingGroup4 = p1TimingOnPageClickList.timingGroups.add(myRectangle4P1, 0) 
	Set p1timingGroup5 = p1TimingOnPageClickList.timingGroups.add(myRectangle5P1, 0) 
	Set p1timingGroup6 = p1TimingOnPageClickList.timingGroups.add(myRectangle6P1, 0) 
	Rem Link Rectangle 6 and 7
	p1timingGroup6.timingTargets.add myRectangle7P1,0
	Set p1timingGroup7 = p1TimingOnPageClickList.timingGroups.add(myRectangle8P1, 0)
	Rem 
	Rem Page 2
	Rem 
	Set myMotionPreset = myInDesign.MotionPresets.Item("twirl")
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(2), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(.25,0,1,11.111), "Animation Events", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(1.25,1,1.625,10.5), "On Page Load", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(2.25,1,2.625,10.5), "On Page Click", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(3.25,1,3.625,10.5), "On Click (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(4.25,1,4.625,10.5), "On Roll Over (Self)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(5.25,1,5.625,10.5), "On Button Event (On Click)", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.pages.item(2), Array(6.25,1,6.625,10.5), "On State Load of Multi-State Object", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P2 = myMakeRectangle(myDocument.pages.item(2), Array(1.625,1,2,2), "On Page Load Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P2 = myMakeRectangle(myDocument.pages.item(2), Array(2.625,1,3,2), "On Page Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P2 = myMakeRectangle(myDocument.pages.item(2), Array(3.625,1,4,2), "Self Click Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P2 = myMakeRectangle(myDocument.pages.item(2), Array(4.625,1,5,2), "Self Roll Over Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P2 = myMakeRectangle(myDocument.pages.item(2), Array(5.625,1,6,2), "On Button Event (On Click) Rectangle", myPurple, myNoneSwatch, 0)
	Rem Apply the motion preset to the rectangles.
	myRectangle1P2.AnimationSettings.Preset = myMotionPreset
	myRectangle2P2.AnimationSettings.Preset = myMotionPreset
	myRectangle3P2.AnimationSettings.Preset = myMotionPreset
	myRectangle4P2.AnimationSettings.Preset = myMotionPreset
	myRectangle5P2.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myRectangle5P2.
	Set myPlayAnimationButton = myDocument.Pages.Item(2).Buttons.Add
	myPlayAnimationButton.GeometricBounds = Array(5.625,3,6,4)
	myPlayAnimationButton.Name = "Play Animation Button"
	myPlayAnimationButton.FillColor = myGreen
	myPlayAnimationButton.StrokeColor = myNoneSwatch
	Set myAnimationBehavior = myPlayAnimationButton.AnimationBehaviors.Add
	myAnimationBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	myAnimationBehavior.EnableBehavior = True
	myAnimationBehavior.AnimatedPageItem = myRectangle5P2
	myAnimationBehavior.Operation = idAnimationPlayOperations.idPlay
	Rem Add a Multi-State Object (MSO).
	Set myMSO = myDocument.Pages.Item(2).multiStateObjects.add
	myMSO.GeometricBounds = Array(6.625,1,7,2)
	myMSO.Name = "Simple MSO"
	myMSO.InitiallyHidden = True
	Rem Name default states.
	myMSO.states.item(1).Name = "Top State"
	Set myTopState = myMSO.States.Item(1)
	myMSO.states.item(2).Name = "Second State"
	Set mySecondState = myMSO.States.Item(2)
	Set myThirdState = myMSO.States.Add
	myThirdState.Name = "Third State"
	Rem Add page items to the states.
	Set myRectangleMSO = myMakeRectangle(myTopState, Array(6.625,1,7,2), "Top State Rectangle", myPurple, myNoneSwatch, 0)
	myRectangleMSO.AnimationSettings.Preset = myMotionPreset
	Set myOvalMSO = myMakeRectangle(mySecondState, Array(6.625,1,7,2), "Second State Oval", myPurple, myNoneSwatch, 0)
	myOvalMSO.ConvertShape idConvertShapeOptions.idConvertToOval
	myOvalMSO.AnimationSettings.Preset = myMotionPreset
	Set myPolygonMSO = myMakeRectangle(myThirdState, Array(6.625,1,7,2), "Third State Polygon", myPurple, myNoneSwatch, 0)
	myPolygonMSO.ConvertShape idConvertShapeOptions.idConvertToPolygon
	myPolygonMSO.AnimationSettings.Preset = myMotionPreset
	Rem Add a button to control the animation of myMSO.
	Set myPlayMSOButton = myDocument.pages.item(2).buttons.add
	myPlayMSOButton.GeometricBounds = Array(6.625,3,7,4)
	myPlayMSOButton.Name = "Go to Next State of MSO Button"
	myPlayMSOButton.FillColor = myGreen
	myPlayMSOButton.StrokeColor = myNoneSwatch
	Set myMSOBehavior = myPlayMSOButton.GotoNextStateBehaviors.Add
	myMSOBehavior.AssociatedMultiStateObject = myMSO
	myMSOBehavior.LoopsToNextOrPrevious = True
	myMSOBehavior.BehaviorEvent = idBehaviorEvents.idMouseDown
	Rem Page 2 timing section:
	Set mySecondSpreadTimingSettings = myDocument.spreads.item(2).timingSettings
	Rem Remove the default timing list.
	mySecondSpreadTimingSettings.TimingLists.Item(1).Delete
	Rem Create On Page Load
	Set mySecondPageLoadTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageLoad)
	Set secondSpreadTimingG1 = mySecondPageLoadTimingList.TimingGroups.Add(myRectangle1P2, 0)
	Rem Create On Page Click
	Set mySecondPageClickTimingList = mySecondSpreadTimingSettings.TimingLists.add(idDynamicTriggerEvents.idOnPageClick)
	Set secondSpreadTimingG2 = mySecondPageClickTimingList.TimingGroups.Add(myRectangle2P2, 0)
	Rem Create Self Click
	Set myRectangle3P2TimingList = myRectangle3P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfClick)
	Rem Create Self Roll Over
	Set myRectangle4P2TimingList = myRectangle4P2.TimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnSelfRollover)	
	Rem 
	Rem Page 3
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(3), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.pages.item(3), Array(.25,0,1,11.111), "Additional Animation Properties and Settings", "Myriad Pro", 28, idJustification.idCenterAlign, False
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,1,1.625,10.5), "Duration: 2 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,1,2.625,10.5), "Duration: .5 seconds", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,1,3.625,10.5), "Speed: Ease In", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,1,4.625,10.5), "Speed: Ease Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(5.25,1,5.625,10.5), "Speed: Ease In and Out", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(6.25,1,6.625,10.5), "Play Twice", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(7.25,1,7.625,10.5), "Loop", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(1.25,5,1.625,10.5), "Hide Until Animated", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(2.25,5,2.625,10.5), "Hide After Animating", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(3.25,5,3.625,10.5), "Origin Upper Left Corner", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(3), Array(4.25,5,4.625,10.5), "Origin Right, Vertical Center", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,1,2,2), "2-Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle2P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,1,3,2), ".5 Second Duration Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle3P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,1,4,2), "Ease In Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle4P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,1,5,2), "Ease Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle5P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(5.625,1,6,2), "Ease In and Out Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle6P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(6.625,1,7,2), "Play Twice Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle7P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(7.625,1,8,2), "Loop Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle8P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(1.625,5,2,6), "Hide Until Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle9P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(2.625,5,3,6), "Hide After Animated Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle10P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(3.625,5,4,6), "Origin Upper Left Rectangle", myPurple, myNoneSwatch, 0)
	Set myRectangle11P3 = myMakeRectangle(myDocument.Pages.Item(3), Array(4.625,5,5,6), "Origin Right Center Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P3.AnimationSettings.Duration = 2
	myRectangle1P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle2P3.AnimationSettings.Duration = 0.5
	myRectangle2P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(11,180))
	myRectangle3P3.AnimationSettings.Duration = 2
	myRectangle3P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle3P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseIn
	myRectangle4P3.AnimationSettings.Duration = 2
	myRectangle4P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle4P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseOut
	myRectangle5P3.AnimationSettings.Duration = 2
	myRectangle5P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle5P3.AnimationSettings.EaseType = idAnimationEaseOptions.idEaseInOut
	myRectangle6P3.AnimationSettings.Duration = 2
	myRectangle6P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle6P3.AnimationSettings.Plays = 2
	myRectangle7P3.AnimationSettings.Duration = 2
	myRectangle7P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle7P3.AnimationSettings.PlaysLoop = True
	myRectangle8P3.AnimationSettings.Duration = 2
	myRectangle8P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle8P3.AnimationSettings.InitiallyHidden = True
	myRectangle8P3.AnimationSettings.HiddenAfter = False
	myRectangle9P3.AnimationSettings.Duration = 2
	myRectangle9P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle9P3.AnimationSettings.InitiallyHidden = False
	myRectangle9P3.AnimationSettings.HiddenAfter = True
	myRectangle10P3.AnimationSettings.Duration = 2
	myRectangle10P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle10P3.AnimationSettings.TransformOffsets = Array(0, 0)
	myRectangle11P3.AnimationSettings.Duration = 2
	myRectangle11P3.AnimationSettings.RotationArray = Array(Array(0,0),Array(47,180))
	myRectangle11P3.AnimationSettings.TransformOffsets = Array(1.0,0.5)
	Rem 
	Rem Page 4
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(4), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(.25,0,1,11.111), "Animate Options", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(1.25,1,1.625,10.5), "Animate: From Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(2.25,1,2.625,10.5), "Animate: To Current Appearance", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(4), Array(3.25,1,3.625,10.5), "Animate: To Current Location", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(1.625,1,2,2), "Animate From Current Appearance", myPurple, myNoneSwatch, 0)
	Set myRectangle2P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(2.625,1,3,2), "Animate To Current Appearance", myPurple, myNoneSwatch, 0)
	set myRectangle3P4 = myMakeRectangle(myDocument.Pages.Item(4), Array(3.625,1,4,2), "Animate To Current Location", myPurple, myNoneSwatch, 0)
	Rem Set animation properties.
	myRectangle1P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle1P4.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance
	myRectangle2P4.AnimationSettings.Preset =  myInDesign.MotionPresets.Item("move-right-grow")
	myRectangle2P4.AnimationSettings.DesignOption = idDesignOptions.idToCurrentAppearance
	myRectangle3P4.AnimationSettings.Preset = myInDesign.MotionPresets.Item("fly-in-left")
	Rem 
	Rem Page 5
	Rem 
	myDocument.Pages.Add
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(5), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(.25,0,1,11.111), "Timing Panel - Timing Groups and Delays", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text labels.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,1,1.625,10.5), "A-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,1,2.625,10.5), "A-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,1,3.625,10.5), "A-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,1,4.625,10.5), "A-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,1,5.625,10.5), "B-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(6.25,1,6.625,10.5), "B-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(7.25,1,7.625,10.5), "B-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(1.25,5,1.625,10.5), "C-1", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(2.25,5,2.625,10.5), "C-2", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(3.25,5,3.625,10.5), "C-3", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(4.25,5,4.625,10.5), "C-4", "Myriad Pro", 18, idJustification.idLeftAlign, True
	myMakeTextFrame myInDesign, myDocument.Pages.Item(5), Array(5.25,5,5.625,10.5), "C-5", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangles.
	Set myRectangle1P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,1,2,2), "A-1", myPurple, myNoneSwatch, 0)
	Set myRectangle2P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,1,3,2), "A-2", myPurple, myNoneSwatch, 0)
	Set myRectangle3P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,1,4,2), "A-3", myPurple, myNoneSwatch, 0)
	Set myRectangle4P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,1,5,2), "A-4", myPurple, myNoneSwatch, 0)
	Set myRectangle5P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,1,6,2), "B-1", myGreen, myNoneSwatch, 0)
	Set myRectangle6P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(6.625,1,7,2), "B-2", myGreen, myNoneSwatch, 0)
	Set myRectangle7P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(7.625,1,8,2), "B-3", myGreen, myNoneSwatch, 0)
	Set myRectangle8P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(1.625,5,2,6), "C-1", myBlue, myNoneSwatch, 0)
	Set myRectangle9P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(2.625,5,3,6), "C-2", myBlue, myNoneSwatch, 0)
	Set myRectangle10P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(3.625,5,4,6), "C-3", myBlue, myNoneSwatch, 0)
	Set myRectangle11P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(4.625,5,5,6), "C-4", myBlue, myNoneSwatch, 0)
	Set myRectangle12P5 = myMakeRectangle(myDocument.Pages.Item(5), Array(5.625,5,6,6), "C-5", myBlue, myNoneSwatch, 0)
	Rem Animation settings (note that you cannot use a page item as the target of a timing group
	Rem if you have not applied animation settings to the it).
	myRectangle1P5.AnimationSettings.Preset = myMotionPreset
	myRectangle2P5.AnimationSettings.Preset = myMotionPreset
	myRectangle3P5.AnimationSettings.Preset = myMotionPreset
	myRectangle4P5.AnimationSettings.Preset = myMotionPreset
	myRectangle5P5.AnimationSettings.Preset = myMotionPreset
	myRectangle6P5.AnimationSettings.Preset = myMotionPreset
	myRectangle7P5.AnimationSettings.Preset = myMotionPreset
	myRectangle8P5.AnimationSettings.Preset = myMotionPreset
	myRectangle9P5.AnimationSettings.Preset = myMotionPreset
	myRectangle10P5.AnimationSettings.Preset = myMotionPreset
	myRectangle11P5.AnimationSettings.Preset = myMotionPreset
	myRectangle12P5.AnimationSettings.Preset = myMotionPreset
	Rem Page 5 timing section:
	Set myFifthSpreadTimingSettings = myRectangle1P5.parent.TimingSettings
	myFifthSpreadTimingSettings.TimingLists.item(1).Delete
	Set myFifthPageLoadTimingList = myFifthSpreadTimingSettings.TimingLists.Add(idDynamicTriggerEvents.idOnPageLoad)
	Rem A group.
	Set myFifthSpreadTimingG1 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle1P5, 0)
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle2P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle3P5, 0
	myFifthSpreadTimingG1.TimingTargets.Add myRectangle4P5, 0
	Rem B group.
	Set myFifthSpreadTimingG2 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle5P5, 1)
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle6P5,.5
	myFifthSpreadTimingG2.TimingTargets.Add myRectangle7P5, 1
	Rem Enable Group Loop
	myFifthSpreadTimingG2.PlaysLoop = True
	Rem C group.
	Set myFifthSpreadTimingG3 = myFifthPageLoadTimingList.TimingGroups.Add(myRectangle8P5, .25)
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle9P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle10P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle11P5, .25
	myFifthSpreadTimingG3.TimingTargets.Add myRectangle12P5, .25
	Rem Enable Group Plays 2
	myFifthSpreadTimingG3.Plays = 2
	Rem 
	Rem Page 6
	Rem 
	myDocument.pages.add()
	Rem Create a background rectangle.
	myMakeRectangle myDocument.Pages.Item(6), Array(0,0,8.333,11.111), "Background Rectangle", myLightGray, myNoneSwatch, 0
	Rem Create a headline text frame.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(.25,0,1,11.111), "Scripted Animation with Multiple Property Changes", "Myriad Pro", 28, idJustification.idCenterAlign, false
	Rem Add text label.
	myMakeTextFrame myInDesign, myDocument.Pages.Item(6), Array(1.25,1,1.625,10.5), "6-Second Animation with one or more property changes per second", "Myriad Pro", 18, idJustification.idLeftAlign, True
	Rem Add rectangle.
	Set myRectangle1P6 = myMakeRectangle(myDocument.Pages.Item(6), Array(1.625,1,2,2), "Scripted Animation Rectangle", myPurple, myNoneSwatch, 0)
	Rem Set duration before adding keyframes when scripting animations
	myRectangle1P6.AnimationSettings.duration = 6
	Rem Assumes 24 Frames Per Second (FPS)
	Rem 23 = 1 second, 47 = 2 seconds, 71 = 3 seconds, 95 = 4 seconds, 119 = 5 seconds, 143 = 6 seconds
	mySetUnits myInDesign, idMeasurementUnits.idPoints
	Rem Note that the animation here is created with motionPath, which allows for setting keyframes that correspond to points in the path
	myRectangle1P6.AnimationSettings.MotionPath = Array(Array(0, Array(Array(0, 0), Array(0, 0), Array(0, 0))), Array(23, Array(Array(200, 0), Array(200, 0), Array(200, 0))), Array(47, Array(Array(200, 200), Array(200, 200), Array(200, 200))), Array(119, Array(Array(0, 200), Array(0, 200), Array(0, 200))), Array(143, Array(Array(0, 0), Array(0, 0), Array(0, 0))))
	mySetUnits myInDesign, idMeasurementUnits.idInches
	Rem Note that this animation allows setting multiple changes in opacity, scale and rotation that 
	Rem correspond to points in the motion path.  This functionality is not available in the Animation panel UI.
	myRectangle1P6.AnimationSettings.RotationArray =  Array(Array(0, 0), Array(23, 180), Array(47, 0), Array(71, -180), Array(95, 0), Array(119, 180), Array(143, -360))
	myRectangle1P6.AnimationSettings.ScaleXArray = Array( Array(0, 100.0 ), Array(23, 200.0), Array(47, 100.0), Array(71, 300.0), Array(95, 100.0), Array(119, 200.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.ScaleYArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 300.0), Array(143, 100.0) )
	myRectangle1P6.AnimationSettings.OpacityArray = Array( Array(0, 100.0 ), Array(23, 0.0), Array(47, 100.0), Array(71, 0.0), Array(95, 100.0), Array(119, 0.0), Array(143, 100.0) ) 
	myRectangle1P6.AnimationSettings.Plays = 1
	myRectangle1P6.AnimationSettings.PlaysLoop = False
	myRectangle1P6.AnimationSettings.EaseType = idAnimationEaseOptions.idNoEase
	myRectangle1P6.AnimationSettings.TransformOffsets = Array(0.5, 0.5)
	myRectangle1P6.AnimationSettings.DesignOption = idDesignOptions.idFromCurrentAppearance 
	myRectangle1P6.AnimationSettings.InitiallyHidden = False
	myRectangle1P6.AnimationSettings.HiddenAfter = False		
End Function
Rem Utility functions.
Function mySetUnits(myInDesign, myUnits)
	myInDesign.Documents.Item(1).ViewPreferences.HorizontalMeasurementUnits = myUnits
	myInDesign.Documents.Item(1).ViewPreferences.VerticalMeasurementUnits = myUnits
End Function
Function myMakeTextFrame(myInDesign, myPage, myBounds, myString, myFontName, myPointSize, myJustification, myFitToContent)
	Set myTextFrame = myPage.TextFrames.Add
	myTextFrame.GeometricBounds = myBounds
	myTextFrame.Texts.Item(1).InsertionPoints.Item(1).Contents = myString
	myTextFrame.Texts.Item(1).ParentStory.AppliedFont = myInDesign.Fonts.Item(myFontName)
	myTextFrame.Texts.Item(1).ParentStory.PointSize = myPointSize
	myTextFrame.Texts.Item(1).ParentStory.FillColor = myInDesign.Documents.Item(1).Swatches.Item("Black")
	myTextFrame.Texts.Item(1).Justification = myJustification
	If myFitToContent = True Then
		myTextFrame.Fit idFitOptions.idFrameToContent
	End If
	Set myMakeTextFrame = myTextFrame
End Function
Function myMakeRectangle(myPage, myBounds, myString, myFillColor,  myStrokeColor, myStrokeWeight)
	Set myRectangle = myPage.rectangles.Add
	myRectangle.GeometricBounds = myBounds
	myRectangle.fillColor = myFillColor
	myRectangle.strokeWeight = myStrokeWeight
	myRectangle.strokeColor = myStrokeColor
	myRectangle.name = myString
	Set myMakeRectangle = myRectangle
End Function
Function myMakeColor(myInDesign, myColorName, myColorSpace, myColorModel, myColorValue)
	Set myDocument = myInDesign.Documents.Item(1)
	Rem Something like a try...catch for VBScript.
    On Error Resume Next
    Set myColor = myDocument.Colors.Item(myColorName)
    If Err.Number <> 0 Then
        Set myColor = myDocument.Colors.Add
    End If
    Err.Clear
    On Error GoTo 0
	myColor.Name = myColorName
	myColor.Space = myColorSpace
	myColor.Model = myColorModel
	myColor.ColorValue = myColorValue
	Set myMakeColor = myColor
End Function

'' SIG '' Begin signature block
'' SIG '' MIIhPQYJKoZIhvcNAQcCoIIhLjCCISoCAQExDzANBglg
'' SIG '' hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
'' SIG '' BgEEAYI3AgEeMCQCAQEEEE7wKRaZJ7VNj+Ws4Q8X66sC
'' SIG '' AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
'' SIG '' iNuiPhBvN96pkhzqOKijDNkXuTftEX7TMVwVEUEbneyg
'' SIG '' ggyUMIIF0DCCBLigAwIBAgIQCHK5i9aO5k82w+FiDw5C
'' SIG '' dzANBgkqhkiG9w0BAQsFADBsMQswCQYDVQQGEwJVUzEV
'' SIG '' MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3
'' SIG '' d3cuZGlnaWNlcnQuY29tMSswKQYDVQQDEyJEaWdpQ2Vy
'' SIG '' dCBFViBDb2RlIFNpZ25pbmcgQ0EgKFNIQTIpMB4XDTIw
'' SIG '' MTIxOTAwMDAwMFoXDTIyMTIyMTIzNTk1OVowgeYxEzAR
'' SIG '' BgsrBgEEAYI3PAIBAxMCVVMxGTAXBgsrBgEEAYI3PAIB
'' SIG '' AhMIRGVsYXdhcmUxHTAbBgNVBA8MFFByaXZhdGUgT3Jn
'' SIG '' YW5pemF0aW9uMRAwDgYDVQQFEwcyNzQ4MTI5MQswCQYD
'' SIG '' VQQGEwJVUzELMAkGA1UECBMCY2ExETAPBgNVBAcTCFNh
'' SIG '' biBKb3NlMRMwEQYDVQQKEwpBZG9iZSBJbmMuMSwwKgYD
'' SIG '' VQQLEyNJbGx1c3RyYXRvciwgSW5EZXNpZ24sIEluQ29w
'' SIG '' eSwgTXVzZTETMBEGA1UEAxMKQWRvYmUgSW5jLjCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKraHbKp
'' SIG '' 7LWhQb1eUijAwzznOPnL0ar6Bh5IyTX0X3Nmx0y/zOPp
'' SIG '' A769ixYCLdufIms+U9xBOpXey6jajunMtomUtqLHkYMN
'' SIG '' DT2jzWOCqLvnwrHjehFxLYwYIt9ymU0VqJHPcIO+0lfA
'' SIG '' s4ZoskzD5OepJsCVjURfwILDS/l51c42dKXqbPmr25vz
'' SIG '' UQBlKIg7JV7JJGj29DQMOeCI9LSY4dAUYsfaEfDx0dcb
'' SIG '' T/oDlUZAH/mGrvFonoqGwLDNNSpWkFauC3ryUlgMJ6if
'' SIG '' JX9iZIrdm6Glo/EvxbsHMzsL2TclgBXoa0mYq4PYgMH1
'' SIG '' 5XYNA9y4x7QNLRmWPpXU+4gnfN0CAwEAAaOCAfEwggHt
'' SIG '' MB8GA1UdIwQYMBaAFI/ofvBtMmoABSPHcJdqOpD/a+rU
'' SIG '' MB0GA1UdDgQWBBS5nvze3WzR/65rffm/COInbJUTtzAu
'' SIG '' BgNVHREEJzAloCMGCCsGAQUFBwgDoBcwFQwTVVMtREVM
'' SIG '' QVdBUkUtMjc0ODEyOTAOBgNVHQ8BAf8EBAMCB4AwEwYD
'' SIG '' VR0lBAwwCgYIKwYBBQUHAwMwewYDVR0fBHQwcjA3oDWg
'' SIG '' M4YxaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0VWQ29k
'' SIG '' ZVNpZ25pbmdTSEEyLWcxLmNybDA3oDWgM4YxaHR0cDov
'' SIG '' L2NybDQuZGlnaWNlcnQuY29tL0VWQ29kZVNpZ25pbmdT
'' SIG '' SEEyLWcxLmNybDBLBgNVHSAERDBCMDcGCWCGSAGG/WwD
'' SIG '' AjAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdp
'' SIG '' Y2VydC5jb20vQ1BTMAcGBWeBDAEDMH4GCCsGAQUFBwEB
'' SIG '' BHIwcDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
'' SIG '' aWNlcnQuY29tMEgGCCsGAQUFBzAChjxodHRwOi8vY2Fj
'' SIG '' ZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRFVkNvZGVT
'' SIG '' aWduaW5nQ0EtU0hBMi5jcnQwDAYDVR0TAQH/BAIwADAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAQEALl6DDJXB+ruS0J/n4zd6
'' SIG '' IxqKGcJnnn72tgm50zJjxjqD9f4gMlY5lFA4Dcz9D6ur
'' SIG '' Yc734LqeT9p+oUv2PI4KdFMpSmhdrKLkI8eTK46NHVW8
'' SIG '' U/GZctdsVZR1JvtI1ByrH/DkQS7HTKWwtbyOkKU7lfYK
'' SIG '' HIS+qUso64cM6M2asUym8CdN/3FbwJ9dGJDX9yfMISbX
'' SIG '' oIDfInSnVDD+Z9EnnpsEw9obZwNHaGdd1NJRuPrlwatk
'' SIG '' YdBJuo5kN5/eBMYb95FbK8zZf8e+5FTnEJ0PmxRakjlF
'' SIG '' xh5Zg3CCjiIjr3w/uUkOaa2PjpkNy/vuUYxCuJb53Ca6
'' SIG '' i+n/WMWWjYJLNDCCBrwwggWkoAMCAQICEAPxtOFfOoLx
'' SIG '' FJZ4s9fYR1wwDQYJKoZIhvcNAQELBQAwbDELMAkGA1UE
'' SIG '' BhMCVVMxFTATBgNVBAoTDERpZ2lDZXJ0IEluYzEZMBcG
'' SIG '' A1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTErMCkGA1UEAxMi
'' SIG '' RGlnaUNlcnQgSGlnaCBBc3N1cmFuY2UgRVYgUm9vdCBD
'' SIG '' QTAeFw0xMjA0MTgxMjAwMDBaFw0yNzA0MTgxMjAwMDBa
'' SIG '' MGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
'' SIG '' dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20x
'' SIG '' KzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2lnbmlu
'' SIG '' ZyBDQSAoU0hBMikwggEiMA0GCSqGSIb3DQEBAQUAA4IB
'' SIG '' DwAwggEKAoIBAQCnU/oPsrUT8WTPhID8roA10bbXx6Ms
'' SIG '' rBosrPGErDo1EjqSkbpX5MTJ8y+oSDy31m7clyK6UXlh
'' SIG '' r0MvDbebtEkxrkRYPqShlqeHTyN+w2xlJJBVPqHKI3zF
'' SIG '' QunEemJFm33eY3TLnmMl+ISamq1FT659H8gTy3WbyeHh
'' SIG '' ivgLDJj0yj7QRap6HqVYkzY0visuKzFYZrQyEJ+d8FKh
'' SIG '' 7+g+03byQFrc+mo9G0utdrCMXO42uoPqMKhM3vELKlhB
'' SIG '' iK4AiasD0RaCICJ2615UOBJi4dJwJNvtH3DSZAmALeK2
'' SIG '' nc4f8rsh82zb2LMZe4pQn+/sNgpcmrdK0wigOXn93b89
'' SIG '' OgklAgMBAAGjggNYMIIDVDASBgNVHRMBAf8ECDAGAQH/
'' SIG '' AgEAMA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggr
'' SIG '' BgEFBQcDAzB/BggrBgEFBQcBAQRzMHEwJAYIKwYBBQUH
'' SIG '' MAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBJBggr
'' SIG '' BgEFBQcwAoY9aHR0cDovL2NhY2VydHMuZGlnaWNlcnQu
'' SIG '' Y29tL0RpZ2lDZXJ0SGlnaEFzc3VyYW5jZUVWUm9vdENB
'' SIG '' LmNydDCBjwYDVR0fBIGHMIGEMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMECgPqA8hjpodHRwOi8v
'' SIG '' Y3JsNC5kaWdpY2VydC5jb20vRGlnaUNlcnRIaWdoQXNz
'' SIG '' dXJhbmNlRVZSb290Q0EuY3JsMIIBxAYDVR0gBIIBuzCC
'' SIG '' AbcwggGzBglghkgBhv1sAwIwggGkMDoGCCsGAQUFBwIB
'' SIG '' Fi5odHRwOi8vd3d3LmRpZ2ljZXJ0LmNvbS9zc2wtY3Bz
'' SIG '' LXJlcG9zaXRvcnkuaHRtMIIBZAYIKwYBBQUHAgIwggFW
'' SIG '' HoIBUgBBAG4AeQAgAHUAcwBlACAAbwBmACAAdABoAGkA
'' SIG '' cwAgAEMAZQByAHQAaQBmAGkAYwBhAHQAZQAgAGMAbwBu
'' SIG '' AHMAdABpAHQAdQB0AGUAcwAgAGEAYwBjAGUAcAB0AGEA
'' SIG '' bgBjAGUAIABvAGYAIAB0AGgAZQAgAEQAaQBnAGkAQwBl
'' SIG '' AHIAdAAgAEMAUAAvAEMAUABTACAAYQBuAGQAIAB0AGgA
'' SIG '' ZQAgAFIAZQBsAHkAaQBuAGcAIABQAGEAcgB0AHkAIABB
'' SIG '' AGcAcgBlAGUAbQBlAG4AdAAgAHcAaABpAGMAaAAgAGwA
'' SIG '' aQBtAGkAdAAgAGwAaQBhAGIAaQBsAGkAdAB5ACAAYQBu
'' SIG '' AGQAIABhAHIAZQAgAGkAbgBjAG8AcgBwAG8AcgBhAHQA
'' SIG '' ZQBkACAAaABlAHIAZQBpAG4AIABiAHkAIAByAGUAZgBl
'' SIG '' AHIAZQBuAGMAZQAuMB0GA1UdDgQWBBSP6H7wbTJqAAUj
'' SIG '' x3CXajqQ/2vq1DAfBgNVHSMEGDAWgBSxPsNpA/i/RwHU
'' SIG '' mCYaCALvY2QrwzANBgkqhkiG9w0BAQsFAAOCAQEAGTNK
'' SIG '' DIEzN9utNsnkyTq7tRsueqLi9ENCF56/TqFN4bHb6YHd
'' SIG '' nwHy5IjV6f4J/SHB7F2A0vDWwUPC/ncr2/nXkTPObNWy
'' SIG '' GTvmLtbJk0+IQI7N4fV+8Q/GWVZy6OtqQb0c1UbVfEnK
'' SIG '' ZjgVwb/gkXB3h9zJjTHJDCmiM+2N4ofNiY0/G//V4BqX
'' SIG '' i3zabfuoxrI6Zmt7AbPN2KY07BIBq5VYpcRTV6hg5ucC
'' SIG '' EqC5I2SiTbt8gSVkIb7P7kIYQ5e7pTcGr03/JqVNYUvs
'' SIG '' RkG4Zc64eZ4IlguBjIo7j8eZjKMqbphtXmHGlreKuWEt
'' SIG '' k7jrDgRD1/X+pvBi1JlqpcHB8GSUgDGCFAEwghP9AgEB
'' SIG '' MIGAMGwxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdp
'' SIG '' Q2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5j
'' SIG '' b20xKzApBgNVBAMTIkRpZ2lDZXJ0IEVWIENvZGUgU2ln
'' SIG '' bmluZyBDQSAoU0hBMikCEAhyuYvWjuZPNsPhYg8OQncw
'' SIG '' DQYJYIZIAWUDBAIBBQCggZwwGQYJKoZIhvcNAQkDMQwG
'' SIG '' CisGAQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisG
'' SIG '' AQQBgjcCARUwLwYJKoZIhvcNAQkEMSIEIBR5CfeCSdKC
'' SIG '' XHFUM4oGpTA7Hj7PWufBZGyVMgjJa1/bMDAGCisGAQQB
'' SIG '' gjcCAQwxIjAgoB6AHABBAGQAbwBiAGUAIABJAG4ARABl
'' SIG '' AHMAaQBnAG4wDQYJKoZIhvcNAQEBBQAEggEAhDZwa4hy
'' SIG '' RtZT6ctr16dPzmezAvEX6nJqDrZhUvfH96E3pTD47ztR
'' SIG '' B75ZvcLKSUM2l7NtzOQk2h7DqTW1mXKPQRmF1kKNYGyS
'' SIG '' BPYZ4xLfZ0k6VCXyxvIcecu9uzC/CcMiG2lGDwosWHRe
'' SIG '' GDPbirrs2WNNZQp/pEr1sS15+mLlO1BoXkjP2hsEp5EQ
'' SIG '' pEcNgIaBZPy25HRPKhpVhVneI+mYgrAq20PRUXJY7O7B
'' SIG '' xPOhbAWowdQKMRNY+EUhRlTktMLJDkFYmPhHjUk2f3pR
'' SIG '' t0WFV0Wucso7p/RyAXL80wuTethJW11iwpseZE5qnMxx
'' SIG '' TKJQKGCIIvKVMZIp+2ubVY3ASqGCEbIwghGuBgorBgEE
'' SIG '' AYI3AwMBMYIRnjCCEZoGCSqGSIb3DQEHAqCCEYswghGH
'' SIG '' AgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQ
'' SIG '' AQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFl
'' SIG '' AwQCAQUABCBMTmVk/NNL6vvoXGZ1nDwYn1eb5z2QHxDG
'' SIG '' MDQlU1vc9QIQV3S3jkeIDzPe2u6lMozIRBgPMjAyMjA0
'' SIG '' MTgxOTAzMzVaoIINfDCCBsYwggSuoAMCAQICEAp6Soie
'' SIG '' yZlCkAZjOE2Gl50wDQYJKoZIhvcNAQELBQAwYzELMAkG
'' SIG '' A1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
'' SIG '' MTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJT
'' SIG '' QTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
'' SIG '' MjAzMjkwMDAwMDBaFw0zMzAzMTQyMzU5NTlaMEwxCzAJ
'' SIG '' BgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
'' SIG '' LjEkMCIGA1UEAxMbRGlnaUNlcnQgVGltZXN0YW1wIDIw
'' SIG '' MjIgLSAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIIC
'' SIG '' CgKCAgEAuSqWI6ZcvF/WSfAVghj0M+7MXGzj4CUu0jHk
'' SIG '' PECu+6vE43hdflw26vUljUOjges4Y/k8iGnePNIwUQ0x
'' SIG '' B7pGbumjS0joiUF/DbLW+YTxmD4LvwqEEnFsoWImAdPO
'' SIG '' w2z9rDt+3Cocqb0wxhbY2rzrsvGD0Z/NCcW5QWpFQiNB
'' SIG '' Wvhg02UsPn5evZan8Pyx9PQoz0J5HzvHkwdoaOVENFJf
'' SIG '' D1De1FksRHTAMkcZW+KYLo/Qyj//xmfPPJOVToTpdhiY
'' SIG '' mREUxSsMoDPbTSSF6IKU4S8D7n+FAsmG4dUYFLcERfPg
'' SIG '' OL2ivXpxmOwV5/0u7NKbAIqsHY07gGj+0FmYJs7g7a5/
'' SIG '' KC7CnuALS8gI0TK7g/ojPNn/0oy790Mj3+fDWgVifnAs
'' SIG '' 5SuyPWPqyK6BIGtDich+X7Aa3Rm9n3RBCq+5jgnTdKEv
'' SIG '' sFR2wZBPlOyGYf/bES+SAzDOMLeLD11Es0MdI1DNkdcv
'' SIG '' nfv8zbHBp8QOxO9APhk6AtQxqWmgSfl14ZvoaORqDI/r
'' SIG '' 5LEhe4ZnWH5/H+gr5BSyFtaBocraMJBr7m91wLA2JrII
'' SIG '' O/+9vn9sExjfxm2keUmti39hhwVo99Rw40KV6J67m0uy
'' SIG '' 4rZBPeevpxooya1hsKBBGBlO7UebYZXtPgthWuo+epiS
'' SIG '' Uc0/yUTngIspQnL3ebLdhOon7v59emsCAwEAAaOCAYsw
'' SIG '' ggGHMA4GA1UdDwEB/wQEAwIHgDAMBgNVHRMBAf8EAjAA
'' SIG '' MBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1UdIAQZ
'' SIG '' MBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNVHSME
'' SIG '' GDAWgBS6FtltTYUvcyl2mi91jGogj57IbzAdBgNVHQ4E
'' SIG '' FgQUjWS3iSH+VlhEhGGn6m8cNo/drw0wWgYDVR0fBFMw
'' SIG '' UTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQuY29t
'' SIG '' L0RpZ2lDZXJ0VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRp
'' SIG '' bWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUHAQEEgYMw
'' SIG '' gYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2lj
'' SIG '' ZXJ0LmNvbTBYBggrBgEFBQcwAoZMaHR0cDovL2NhY2Vy
'' SIG '' dHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0
'' SIG '' UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNydDAN
'' SIG '' BgkqhkiG9w0BAQsFAAOCAgEADS0jdKbR9fjqS5k/AeT2
'' SIG '' DOSvFp3Zs4yXgimcQ28BLas4tXARv4QZiz9d5YZPvpM6
'' SIG '' 3io5WjlO2IRZpbwbmKrobO/RSGkZOFvPiTkdcHDZTt8j
'' SIG '' ImzV3/ZZy6HC6kx2yqHcoSuWuJtVqRprfdH1AglPgtal
'' SIG '' c4jEmIDf7kmVt7PMxafuDuHvHjiKn+8RyTFKWLbfOHzL
'' SIG '' +lz35FO/bgp8ftfemNUpZYkPopzAZfQBImXH6l50pls1
'' SIG '' klB89Bemh2RPPkaJFmMga8vye9A140pwSKm25x1gvQQi
'' SIG '' FSVwBnKpRDtpRxHT7unHoD5PELkwNuTzqmkJqIt+ZKJl
'' SIG '' lBH7bjLx9bs4rc3AkxHVMnhKSzcqTPNc3LaFwLtwMFV4
'' SIG '' 1pj+VG1/calIGnjdRncuG3rAM4r4SiiMEqhzzy350yPy
'' SIG '' nhngDZQooOvbGlGglYKOKGukzp123qlzqkhqWUOuX+r4
'' SIG '' DwZCnd8GaJb+KqB0W2Nm3mssuHiqTXBt8CzxBxV+NbTm
'' SIG '' tQyimaXXFWs1DoXW4CzM4AwkuHxSCx6ZfO/IyMWMWGmv
'' SIG '' qz3hz8x9Fa4Uv4px38qXsdhH6hyF4EVOEhwUKVjMb9N/
'' SIG '' y77BDkpvIJyu2XMyWQjnLZKhGhH+MpimXSuX4IvTnMxt
'' SIG '' tQ2uR2M4RxdbbxPaahBuH0m3RFu0CAqHWlkEdhGhp3cC
'' SIG '' ExwwggauMIIElqADAgECAhAHNje3JFR82Ees/ShmKl5b
'' SIG '' MA0GCSqGSIb3DQEBCwUAMGIxCzAJBgNVBAYTAlVTMRUw
'' SIG '' EwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
'' SIG '' dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0
'' SIG '' IFRydXN0ZWQgUm9vdCBHNDAeFw0yMjAzMjMwMDAwMDBa
'' SIG '' Fw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVTMRcw
'' SIG '' FQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMy
'' SIG '' RGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1
'' SIG '' NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3DQEB
'' SIG '' AQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE
'' SIG '' 8pE3qZdRodbSg9GeTKJtoLDMg/la9hGhRBVCX6SI82j6
'' SIG '' ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0hNoR8XOx
'' SIG '' s+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt
'' SIG '' 69OxtXXnHwZljZQp09nsad/ZkIdGAHvbREGJ3HxqV3rw
'' SIG '' N3mfXazL6IRktFLydkf3YYMZ3V+0VAshaG43IbtArF+y
'' SIG '' 3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLF
'' SIG '' uk4fsbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu9Yem
'' SIG '' j052FVUmcJgmf6AaRyBD40NjgHt1biclkJg6OBGz9vae
'' SIG '' 5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0
'' SIG '' QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/w
'' SIG '' ojzKQtwYSH8UNM/STKvvmz3+DrhkKvp1KCRB7UK/BZxm
'' SIG '' SVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T/jnA
'' SIG '' +bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjB
'' SIG '' Jgj5FBASA31fI7tk42PgpuE+9sJ0sj8eCXbsq11GdeJg
'' SIG '' o1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzSM7TN
'' SIG '' sQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIB
'' SIG '' ADAdBgNVHQ4EFgQUuhbZbU2FL3MpdpovdYxqII+eyG8w
'' SIG '' HwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08w
'' SIG '' DgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUF
'' SIG '' BwMIMHcGCCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYY
'' SIG '' aHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUF
'' SIG '' BzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20v
'' SIG '' RGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8E
'' SIG '' PDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
'' SIG '' b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNV
'' SIG '' HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJ
'' SIG '' KoZIhvcNAQELBQADggIBAH1ZjsCTtm+YqUQiAX5m1tgh
'' SIG '' QuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxpwc8d
'' SIG '' B+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiC
'' SIG '' qBa9qVbPFXONASIlzpVpP0d3+3J0FNf/q0+KLHqrhc1D
'' SIG '' X+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp876i8
'' SIG '' dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6Z
'' SIG '' JxurJB4mwbfeKuv2nrF5mYGjVoarCkXJ38SNoOeY+/um
'' SIG '' nXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3ZpHxcpzp
'' SIG '' SwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNB
'' SIG '' zU+2QJshIUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhzq6YB
'' SIG '' T70/O3itTK37xJV77QpfMzmHQXh6OOmc4d0j/R0o08f5
'' SIG '' 6PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZ
'' SIG '' ynDwN7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3
'' SIG '' OtUVmDG0YgkPCr2B2RP+v6TR81fZvAT6gt4y3wSJ8ADN
'' SIG '' XcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2
'' SIG '' VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8
'' SIG '' MYIDdjCCA3ICAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUG
'' SIG '' A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRp
'' SIG '' Z2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5NiBTSEEyNTYg
'' SIG '' VGltZVN0YW1waW5nIENBAhAKekqInsmZQpAGYzhNhped
'' SIG '' MA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqGSIb3DQEJAzEN
'' SIG '' BgsqhkiG9w0BCRABBDAcBgkqhkiG9w0BCQUxDxcNMjIw
'' SIG '' NDE4MTkwMzM1WjArBgsqhkiG9w0BCRACDDEcMBowGDAW
'' SIG '' BBSFCPOGUVyz0wd9trS3wH8bSl5B3jAvBgkqhkiG9w0B
'' SIG '' CQQxIgQgQ2chxojs8Es9eIzaB+soRsfK1gfiQvgDh7Sb
'' SIG '' GxkQIEwwNwYLKoZIhvcNAQkQAi8xKDAmMCQwIgQgnaaQ
'' SIG '' FcNJxsGJeEW6NYKtcMiPpCk722q+nCvSU5J55jswDQYJ
'' SIG '' KoZIhvcNAQEBBQAEggIAsdCdWkOcGAO4jS/DIhSxItag
'' SIG '' NJLZSTYd4MOEICFwkqn4nppCk+ZYWBJ9n871CVPtdLVW
'' SIG '' ETV9cdOtbwQWemmBKe1izO+uKsNavJLSZLcvhO2pixKL
'' SIG '' FtpW4pzMDJr9lP4fUuMLjoJn1NHA5NkeBtiGd0oAfTAG
'' SIG '' rAjVsjJysuIfbzMaOxtHoFguAKJqiV9yZmsYUw/udADI
'' SIG '' SCQXsp5NuVO/zhH02hd0dUV8PppWGj1L85hOjfXy4QCb
'' SIG '' 4pWnncPKK9DDZXBXtGlYV9h2gGISH9g11JX83i55V4Sl
'' SIG '' nP2ZcGgGZl9itQRqDkZDQHG+mr+Rp+IrSfvX3SJXtVIP
'' SIG '' hBHX4lEPyTwqqwhWG70V4i7YgrkVhkt8Q9jVVFJyZUqp
'' SIG '' D4nBfXKUcYl2Ja2fsVYbRP/XlwCLnNnk9IPt0IR+y5MU
'' SIG '' e1RSFIxFZgxAZjX/cXBAcaJoNudr+RKuTw3XepCUG5NE
'' SIG '' vtgzfIqfhPeObHwPaG8++GSUohVT/qNhr2XtmPnTdOho
'' SIG '' BvHx4twVn2M7HH8Ehc5v3sc16QjkzzUUqRli/A8YojBL
'' SIG '' OG60mpfx62iyGY/f7zm2hllx8DfiLTBkU65dYScRM7RF
'' SIG '' zwxzfc+/aEqCURbTdzSbevs+lMsZ7A9/WvkKtElgqLVm
'' SIG '' BCgFUw0jWrFx9tmwHaPENXLILLjq4LyY7i5w3MiB3gI=
'' SIG '' End signature block
